<?php
/**
 * Art Gallery Museum: Block Patterns
 *
 * @package Art Gallery Museum
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'art-gallery-museum',
		array( 'label' => __( 'Art Gallery Museum', 'art-gallery-museum' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'art-gallery-museum/banner-section',
		array(
			'title'      => __( 'Banner Section', 'art-gallery-museum' ),
			'categories' => array( 'art-gallery-museum' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/images/Banner.png\",\"id\":3014,\"dimRatio\":0,\"align\":\"full\",\"className\":\"art-gallery-museum-banner-section\"} -->\n<div class=\"wp-block-cover alignfull art-gallery-museum-banner-section\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3014\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/images/Banner.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":1,\"style\":{\"typography\":{\"fontSize\":\"40px\"}}} -->\n<h1 class=\"has-text-align-center\" style=\"font-size:40px\">One of the World's Largest Collection </h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"0px\"},\"color\":{\"background\":\"#e51937\"},\"typography\":{\"fontSize\":\"15px\"}},\"className\":\"is-style-fill\"} -->\n<div class=\"wp-block-button aligncenter has-custom-font-size is-style-fill\" style=\"font-size:15px\"><a class=\"wp-block-button__link has-background\" style=\"border-radius:0px;background-color:#e51937\">DONATE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'art-gallery-museum/venus-section',
		array(
			'title'      => __( 'Venus Section', 'art-gallery-museum' ),
			'categories' => array( 'art-gallery-museum' ),
			'content'    => "<!-- wp:group {\"className\":\"art-gallery-museum-venus-section pt-5\"} -->\n<div class=\"wp-block-group art-gallery-museum-venus-section pt-5\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"40px\"}},\"className\":\"pb-5\"} -->\n<h2 class=\"has-text-align-center pb-5\" style=\"font-size:40px\">Our Venus</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"className\":\"art-gallery-museum-colum-section\"} -->\n<div class=\"wp-block-columns art-gallery-museum-colum-section\"><!-- wp:column {\"className\":\"art-gallery-museum-venus-image-section\"} -->\n<div class=\"wp-block-column art-gallery-museum-venus-image-section\"><!-- wp:image {\"id\":2987,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/images/Venus-image1.png\" alt=\"\" class=\"wp-image-2987\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"backgroundColor\":\"white\",\"className\":\"group1\"} -->\n<div class=\"wp-block-group group1 has-white-background-color has-background\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"22px\"}}} -->\n<h3 style=\"font-size:22px\">Venue Title 1</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. </p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"art-gallery-museum-venus-image-section\"} -->\n<div class=\"wp-block-column art-gallery-museum-venus-image-section\"><!-- wp:image {\"id\":2988,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/images/Venus-image2.png\" alt=\"\" class=\"wp-image-2988\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"backgroundColor\":\"white\",\"className\":\"group1\"} -->\n<div class=\"wp-block-group group1 has-white-background-color has-background\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"22px\"}}} -->\n<h3 style=\"font-size:22px\">Venue Title 2</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. </p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"art-gallery-museum-venus-image-section\"} -->\n<div class=\"wp-block-column art-gallery-museum-venus-image-section\"><!-- wp:image {\"id\":2989,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"" . esc_url(get_template_directory_uri()) . "/images/Venus-image3.png\" alt=\"\" class=\"wp-image-2989\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"backgroundColor\":\"white\",\"className\":\"group1\"} -->\n<div class=\"wp-block-group group1 has-white-background-color has-background\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"22px\"}}} -->\n<h3 style=\"font-size:22px\">Venue Title 3</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. </p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->",
		)
	);
}