<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div class="content-ma">
 *
 * @package Art Gallery Museum
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width">
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?> class="main-bodybox">
	<?php if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
	    do_action( 'wp_body_open' );
	}?>
	<?php if(get_theme_mod('art_gallery_museum_preloader_hide',false)!= '' || get_theme_mod('art_gallery_museum_responsive_preloader_hide',false) != ''){ ?>
    <?php if(get_theme_mod( 'art_gallery_museum_preloader_type','center-square') == 'center-square'){ ?>
	    <div class='preloader'>
		    <div class='preloader-squares'>
				<div class='square'></div>
				<div class='square'></div>
				<div class='square'></div>
				<div class='square'></div>
		    </div>
			</div>
    <?php }else if(get_theme_mod( 'art_gallery_museum_preloader_type') == 'chasing-square') {?>    
      <div class='preloader'>
				<div class='preloader-chasing-squares'>
					<div class='square'></div>
					<div class='square'></div>
					<div class='square'></div>
					<div class='square'></div>
				</div>
			</div>
    <?php }?>
	<?php }?>
	<header role="banner">
		<a class="screen-reader-text skip-link" href="#main"><?php esc_html_e( 'Skip to content', 'art-gallery-museum' ); ?><span class="screen-reader-text"><?php esc_html_e( 'Skip to content ', 'art-gallery-museum' );?></span></a>
		<div id="header">
			<?php if(get_theme_mod('art_gallery_museum_topbar_text') != '' || get_theme_mod('art_gallery_museum_topbar_phoneno') != '' || get_theme_mod('art_gallery_museum_topbar_time') != '' || get_theme_mod('art_gallery_museum_topbar_btn_url') != '' || get_theme_mod('art_gallery_museum_topbar_btn_text') != '') {?>
		  	<div class="topbar">
		  		<div class="container">
		  			<div class="row">
		  				<div class="col-lg-4 col-md-12 align-self-center">
		  					<?php if(get_theme_mod('art_gallery_museum_topbar_text') != '') {?>
		  						<p class="topbar-text mb-lg-0"><?php echo esc_html(get_theme_mod('art_gallery_museum_topbar_text')); ?></p>
		  					<?php }?>
		  				</div>
		  				<div class="col-lg-2 col-md-3 contact align-self-center">
		  					<?php if(get_theme_mod('art_gallery_museum_topbar_phoneno') != '') {?>
		  						<a href="tel:<?php echo esc_attr(get_theme_mod('art_gallery_museum_topbar_phoneno')); ?>" class="mb-md-0 mb-3"><i class="fas fa-phone-volume me-2"></i><?php echo esc_html(get_theme_mod('art_gallery_museum_topbar_phoneno')); ?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('art_gallery_museum_topbar_phoneno')); ?></span></a>
		  					<?php }?>
		  				</div>
		  				<div class="col-lg-3 col-md-4 contact align-self-center">
		  					<?php if(get_theme_mod('art_gallery_museum_topbar_time') != '') {?>
		  						<p class="time mb-md-0"><i class="fas fa-clock me-2"></i><?php echo esc_html(get_theme_mod('art_gallery_museum_topbar_time')); ?></p>
		  					<?php }?>
		  				</div>
		  				<div class="col-lg-3 col-md-5 align-self-center text-md-end text-center member-btn">
		  					<?php if(get_theme_mod('art_gallery_museum_topbar_btn_url') != '' || get_theme_mod('art_gallery_museum_topbar_btn_text') != '') {?>
		  						<a href="<?php echo esc_url(get_theme_mod('art_gallery_museum_topbar_btn_url')); ?>"><i class="far fa-user"></i><span><?php echo esc_html(get_theme_mod('art_gallery_museum_topbar_btn_text')); ?></span><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('art_gallery_museum_topbar_btn_text')); ?></span></a>
		  					<?php }?>
		  				</div>
		  			</div>
		  		</div>
		  	</div>
		  <?php }?>
	  	<div class="menu-section">
	  		<div class="container">
	  			<div class="row">
		  			<div class="col-lg-3 col-md-5 align-self-center">
		  				<div class="logo text-md-start text-center">
				     	 	<?php if ( has_custom_logo() ) : ?>
			     	    	<div class="site-logo"><?php the_custom_logo(); ?></div>
		            <?php endif; ?>
		            <?php if( get_theme_mod( 'art_gallery_museum_site_title',true) != '') { ?>
			            <?php $blog_info = get_bloginfo( 'name' ); ?>
			            <?php if ( ! empty( $blog_info ) ) : ?>
				            <?php if ( is_front_page() && is_home() ) : ?>
				              <h1 class="site-title mt-0 p-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				            <?php else : ?>
				              <p class="site-title mt-0 p-0"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				            <?php endif; ?>
			            <?php endif; ?>
				        <?php }?>
				        <?php if( get_theme_mod( 'art_gallery_museum_site_tagline',true) != '') { ?>
			            <?php
			            $description = get_bloginfo( 'description', 'display' );
			            if ( $description || is_customize_preview() ) :
			            ?>
				            <p class="site-description">
				              <?php echo esc_html($description); ?>
				            </p>
			            <?php endif; ?>
				        <?php }?>
					    </div>
		  			</div>
		  			<div class="col-lg-8 col-md-6 col-6 align-self-center">
		  				<div class="menubox <?php if( get_theme_mod( 'art_gallery_museum_sticky_header') != '') { ?> sticky-header<?php } else { ?>close-sticky <?php } ?>">
								<?php if(has_nav_menu('primary')){ ?>
							   	<div class="toggle-menu responsive-menu text-end">
		               	<button role="tab" onclick="art_gallery_museum_menu_open()"><i class="<?php echo esc_html(get_theme_mod('art_gallery_museum_responsive_open_menu_icon','fas fa-bars'));?> py-1 px-2"></i><span class="screen-reader-text"><?php esc_html_e('Open Menu','art-gallery-museum'); ?></span></button>
		             	</div>
		             	<div id="menu-sidebar" class="nav side-menu ms-xl-5">
		                <nav id="primary-site-navigation" class="primary-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu', 'art-gallery-museum' ); ?>">
		                  <?php 
		                    wp_nav_menu( array( 
		                      'theme_location' => 'primary',
		                      'container_class' => 'main-menu-navigation clearfix' ,
		                      'menu_class' => 'clearfix',
		                      'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav m-0 p-0">%3$s</ul>',
		                      'fallback_cb' => 'wp_page_menu',
		                    ) ); 
		                  ?>
		                  <a href="javascript:void(0)" class="closebtn responsive-menu" onclick="art_gallery_museum_menu_close()"><i class="<?php echo esc_html(get_theme_mod('art_gallery_museum_responsive_close_menu_icon','fas fa-times'));?>"></i><span class="screen-reader-text"><?php esc_html_e('Close Menu','art-gallery-museum'); ?></span></a>
		                </nav>
		            	</div>
		          	<?php }?>
		          </div>
						</div>
						<div class="search-box col-lg-1 col-md-1 col-6 align-self-center">
            	<button type="button" onclick="art_gallery_museum_search_show()" class="p-0"><i class="fas fa-search"></i></button>
		        </div>
		        <div class="search-outer">
              <div class="serach_inner">
              	<?php get_search_form(); ?>
              </div>
            	<button type="button" class="closepop"  onclick="art_gallery_museum_search_hide()">X</span></button>
		        </div>
					</div>
	  		</div>
	  	</div>
		</div>
	</header>