<?php
/**
 * The template for displaying home page.
 *
 * Template Name: Custom Home Page
 *
 * @package Art Gallery Museum
 */
get_header(); ?>

<main id="main" role="main">
  
  <?php if( get_theme_mod( 'art_gallery_museum_slider_hide_show', false) != ''){ ?>
    <div class="<?php if( get_theme_mod('art_gallery_museum_slider_width_options', 'Full Width') == 'Container Width'){ ?>container <?php }?>">
    <section id="slider">
      <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000"> 
        <?php $art_gallery_museum_slider_pages = array();
          for ( $count = 1; $count <= 4; $count++ ) {
            $mod = intval( get_theme_mod( 'art_gallery_museum_slider_page' . $count ));
            if ( 'page-none-selected' != $mod ) {
              $art_gallery_museum_slider_pages[] = $mod;
            }
          }
          if( !empty($art_gallery_museum_slider_pages) ) :
            $args = array(
              'post_type' => 'page',
              'post__in' => $art_gallery_museum_slider_pages,
              'orderby' => 'post__in'
            );
            $query = new WP_Query( $args );
          if ( $query->have_posts() ) :
            $i = 1;
        ?>     
        <div class="carousel-inner" role="listbox">
          <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
          <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
            <a href="<?php echo esc_url( get_permalink() );?>"><?php if(has_post_thumbnail()){
                the_post_thumbnail();
              } else{?>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/Banner.png" alt="" />
              <?php } ?>
            <span class="screen-reader-text"><?php esc_html_e( 'Slider Image','art-gallery-museum');?> </a>
            <div class="carousel-caption">
              <div class="inner_carousel">
                <?php if( get_theme_mod('art_gallery_museum_slider_title',true) != ''){ ?>
                  <h1 class="my-3 p-0"><?php the_title(); ?></h1>
                <?php }?>
                <?php if( get_theme_mod('art_gallery_museum_slider_content',true) != ''){ ?>
                  <p class="mb-3"><?php $art_gallery_museum_excerpt = get_the_excerpt(); echo esc_html( art_gallery_museum_string_limit_words( $art_gallery_museum_excerpt,esc_attr(get_theme_mod('art_gallery_museum_slider_excerpt_length','20')))); ?></p>
                <?php }?>
                <div class="read-btn mt-lg-4 text-center">
                  <a href="<?php echo esc_url( get_permalink() );?>" class="blogbutton-small"><?php echo esc_html('READ MORE', 'art-gallery-museum'); ?><span class="screen-reader-text"><?php echo esc_html('READ MORE', 'art-gallery-museum'); ?></span>
                  </a>
                </div>
              </div>
            </div>
          </div>
          <?php $i++; endwhile; 
          wp_reset_postdata();?>
        </div>
        <?php else : ?>
          <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-bs-slide="prev">
          <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-chevron-left"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Previous','art-gallery-museum');?></span>
        </a>
        <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-bs-slide="next">
          <span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-chevron-right"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Next','art-gallery-museum');?></span>
        </a>
      </div>  
      <div class="clearfix"></div>
    </section> 
  <?php }?>

  <?php do_action( 'art_gallery_museum_before_venues_section' ); ?>

  <?php if( get_theme_mod('art_gallery_museum_venue_category') != '' || get_theme_mod('art_gallery_museum_section_title') != ''){ ?>
    <section id="venue-section" class="py-4">
      <div class="container">
        <?php if(get_theme_mod('art_gallery_museum_section_title') != ''){ ?>
          <h2 class="text-center mb-5"><?php echo esc_html(get_theme_mod('art_gallery_museum_section_title')); ?></h2>
        <?php }?>
        <div class="row">
          <?php 
          $art_gallery_museum_catData=  get_theme_mod('art_gallery_museum_venue_category');
          if($art_gallery_museum_catData){
            $page_query = new WP_Query(array( 'category_name' => esc_html( $art_gallery_museum_catData ,'art-gallery-museum')));?>
            <?php while( $page_query->have_posts() ) : $page_query->the_post(); ?>
              <div class="col-lg-4 col-md-4">
                <div class="venue-box">
                  <?php the_post_thumbnail(); ?> 
                  <div class="venue-content">
                    <h3 class="py-0"><a href="<?php echo esc_url( get_permalink() );?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h3>
                    <p class="mb-0 mt-2"><?php $art_gallery_museum_excerpt = get_the_excerpt(); echo esc_html( art_gallery_museum_string_limit_words( $art_gallery_museum_excerpt,15) ); ?></p>
                  </div>
                </div>
              </div>
            <?php endwhile;
            wp_reset_postdata();
          } ?>
        </div>
      </div>
    </section>
  <?php }?>

  <?php do_action( 'art_gallery_museum_after_venues_section' ); ?>

  <div id="content-ma">
  	<div class="container">
    	<?php while ( have_posts() ) : the_post(); ?>
        <?php the_content(); ?>
      <?php endwhile; // end of the loop. ?>
  	</div>
  </div>
</main>

<?php get_footer(); ?>