<?php
/**
 * The template used for displaying promotion headline
 *
 * @package ScapeShot
 */

if ( $scapeshot_id = get_theme_mod( 'scapeshot_promotion_headline' ) ) {
	$scapeshot_args['page_id'] = absint( $scapeshot_id );
	$scapeshot_args['post_type'] = 'page';
} 

// If $scapeshot_args is empty return false
if ( empty( $scapeshot_args ) ) {
	return;
}

// Create a new WP_Query using the argument previously created
$scapeshot_promotion_headline_query = new WP_Query( $scapeshot_args );
if ( $scapeshot_promotion_headline_query->have_posts() ) :
	while ( $scapeshot_promotion_headline_query->have_posts() ) :
		$scapeshot_promotion_headline_query->the_post();

		if( has_post_thumbnail() ) {
			$scapeshot_thumb = get_the_post_thumbnail_url();
		} else {
			$scapeshot_thumb = trailingslashit( esc_url( get_template_directory_uri() ) ) . 'assets/images/no-thumb-1920x1080.jpg';
		}
		?>
		<div id="promotion-section" class="section promotion-section content-align-center text-align-center section-with-background-image promotion-headline-one">
			<div class="wrapper section-content-wrapper">
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="hentry-inner">
						<div class="post-thumbnail-background" style="background-image: url('<?php echo esc_url( $scapeshot_thumb ); ?>')">
							<a class="cover-link" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
							</a>
						</div>

						<div class="content-wrapper">
							<div class="entry-container">
									<?php $scapeshot_tagline     = get_theme_mod( 'scapeshot_promotion_headline_section_tagline' ); ?>
									<div class="section-heading-wrapper">
										<?php if( $scapeshot_tagline ) : ?>
											<div class="section-subtitle"><?php echo esc_html( $scapeshot_tagline ); ?> </div>
										<?php endif; ?>

										<div class="section-title-wrapper">
											<h2 class="section-title">
												<a href="<?php the_permalink(); ?>">
													<?php the_title(); ?>
												</a>
											</h2>
										</div><!-- .page-title-wrapper -->
									</div><!-- .section-heading-wrapper -->

									<div class="entry-summary">
										<?php the_excerpt(); ?>
									</div><!-- .entry-summary -->
							</div><!-- .entry-container -->
						</div><!-- .content-wrapper -->
					</div><!-- .hentry-inner -->
				</article><!-- #post-## -->
			</div><!-- .wrapper -->
		</div><!-- .section -->
	<?php
	endwhile;
	wp_reset_postdata();
endif;
