<?php

if ( ! class_exists( 'Shapely_Notify_System' ) ) {
	/**
	 * Class Shapely_Notify_System
	 */
	class Shapely_Notify_System extends Epsilon_Notify_System {
		/**
		 * @param $ver
		 *
		 * @return mixed
		 */
		public static function shapely_version_check( $ver ) {
			$shapely = wp_get_theme();

			return version_compare( $shapely['Version'], $ver, '>=' );
		}

		/**
		 * @return bool
		 */
		public static function shapely_is_not_static_page() {
			return 'page' == get_option( 'show_on_front' ) ? true : false;
		}


		/**
		 * @return bool
		 */
		public static function shapely_has_content() {
			$option = get_option( 'shapely_imported_demo', false );
			if ( $option ) {
				return true;
			};

			return false;
		}

		/**
		 * @return bool|mixed
		 */
		public static function shapely_check_import_req() {
			$needs = array(
				'has_content' => self::shapely_has_content(),
				'has_plugin'  => self::shapely_has_plugin( 'shapely-companion' ),
			);

			if ( $needs['has_content'] ) {
				return true;
			}

			if ( $needs['has_plugin'] ) {
				return false;
			}

			return true;
		}

		/**
		 * @return bool
		 */
		public static function shapely_check_plugin_is_installed( $slug ) {
			$slug2 = $slug;
			if ( 'wordpress-seo' === $slug ) {
				$slug2 = 'wp-seo';
			}

			$path = WPMU_PLUGIN_DIR . '/' . $slug . '/' . $slug2 . '.php';
			if ( ! file_exists( $path ) ) {
				$path = WP_PLUGIN_DIR . '/' . $slug . '/' . $slug2 . '.php';

				if ( ! file_exists( $path ) ) {
					$path = false;
				}
			}

			if ( file_exists( $path ) ) {
				return true;
			}

			return false;
		}

		/**
		 * @return bool
		 */
		public static function shapely_check_plugin_is_active( $slug ) {
			$slug2 = $slug;
			if ( 'wordpress-seo' === $slug ) {
				$slug2 = 'wp-seo';
			}

			$path = WPMU_PLUGIN_DIR . '/' . $slug . '/' . $slug2 . '.php';
			if ( ! file_exists( $path ) ) {
				$path = WP_PLUGIN_DIR . '/' . $slug . '/' . $slug2 . '.php';
				if ( ! file_exists( $path ) ) {
					$path = false;
				}
			}

			if ( file_exists( $path ) ) {
				include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

				return is_plugin_active( $slug . '/' . $slug2 . '.php' );
			}
		}

		public static function shapely_has_plugin( $slug = null ) {

			$check = array(
				'installed' => self::check_plugin_is_installed( $slug ),
				'active'    => self::check_plugin_is_active( $slug ),
			);

			if ( ! $check['installed'] || ! $check['active'] ) {
				return false;
			}

			return true;
		}

		public static function shapely_companion_title() {
			$installed = self::check_plugin_is_installed( 'shapely-companion' );
			if ( ! $installed ) {
				return esc_html__( 'Install: Shapely Companion Plugin', 'shapely' );
			}

			$active = self::check_plugin_is_active( 'shapely-companion' );
			if ( $installed && ! $active ) {
				return esc_html__( 'Activate: Shapely Companion Plugin', 'shapely' );
			}

			return esc_html__( 'Install: Shapely Companion Plugin', 'shapely' );
		}

		public static function shapely_yoast_title() {
			$installed = self::check_plugin_is_installed( 'wordpress-seo' );
			if ( ! $installed ) {
				return esc_html__( 'Install: Yoast SEO Plugin', 'shapely' );
			}

			$active = self::check_plugin_is_active( 'wordpress-seo' );
			if ( $installed && ! $active ) {
				return esc_html__( 'Activate: Yoast SEO Plugin', 'shapely' );
			}

			return esc_html__( 'Install: Yoast SEO Plugin', 'shapely' );
		}

		public static function shapely_jetpack_title() {
			$installed = self::check_plugin_is_installed( 'jetpack' );
			if ( ! $installed ) {
				return esc_html__( 'Install: Jetpack by WordPress', 'shapely' );
			}

			$active = self::check_plugin_is_active( 'jetpack' );
			if ( $installed && ! $active ) {
				return esc_html__( 'Activate: Jetpack by WordPress', 'shapely' );
			}

			return esc_html__( 'Install: Jetpack by WordPress', 'shapely' );
		}

		public static function shapely_kaliforms_title() {
			$installed = self::check_plugin_is_installed( 'kali-forms' );
			if ( ! $installed ) {
				return esc_html__( 'Install: Kali Forms', 'shapely' );
			}

			$active = self::check_plugin_is_active( 'kali-forms' );
			if ( $installed && ! $active ) {
				return esc_html__( 'Activate: Kali Forms', 'shapely' );
			}

			return esc_html__( 'Install: Kali Forms', 'shapely' );
		}

		/**
		 * @return string
		 */
		public static function shapely_companion_description() {
			$installed = self::check_plugin_is_installed( 'shapely-companion' );

			if ( ! $installed ) {
				return esc_html__( 'Please install Shapely Companion plugin.', 'shapely' );
			}

			$active = self::check_plugin_is_active( 'shapely-companion' );
			if ( $installed && ! $active ) {
				return esc_html__( 'Please activate Shapely Companion plugin.', 'shapely' );
			}

			return esc_html__( 'Please install Shapely Companion plugin.', 'shapely' );
		}

		/**
		 * @return string
		 */
		public static function shapely_jetpack_description() {
			$installed = self::check_plugin_is_installed( 'jetpack' );

			if ( ! $installed ) {
				return esc_html__( 'Please install Jetpack by WordPress. Note that you won\'t be able to use the Testimonials and Portfolio widgets without it.', 'shapely' );
			}

			$active = self::check_plugin_is_active( 'jetpack' );
			if ( $installed && ! $active ) {
				return esc_html__( 'Please activate Jetpack by WordPress. Note that you won\'t be able to use the Testimonials and Portfolio widgets without it.', 'shapely' );
			}

			return esc_html__( 'Please install Jetpack by WordPress. Note that you won\'t be able to use the Testimonials and Portfolio widgets without it.', 'shapely' );
		}

		public static function shapely_kaliforms_description() {
			$installed = self::check_plugin_is_installed( 'kali-forms' );

			if ( ! $installed ) {
				return esc_html__( 'Please install Kali Forms. Note that you won\'t be able to use Contact widget without it.', 'shapely' );
			}

			$active = self::check_plugin_is_active( 'kali-forms' );
			if ( $installed && ! $active ) {
				return esc_html__( 'Please activate Kali Forms. Note that you won\'t be able to use Contact widget without it.', 'shapely' );
			}

			return esc_html__( 'Please install Kali Forms. Note that you won\'t be able to use Contact widget without it.', 'shapely' );
		}

		public static function shapely_yoast_description() {
			$installed = self::check_plugin_is_installed( 'wordpress-seo' );
			if ( ! $installed ) {
				return esc_html__( 'Please install Yoast SEO plugin.', 'shapely' );
			}

			$active = self::check_plugin_is_active( 'wordpress-seo' );
			if ( $installed && ! $active ) {
				return esc_html__( 'Please activate Yoast SEO plugin.', 'shapely' );
			}

			return esc_html__( 'Please install Yoast SEO plugin.', 'shapely' );

		}

		/**
		 * @return bool
		 */
		public static function shapely_is_not_template_front_page() {
			$page_id = get_option( 'page_on_front' );

			return get_page_template_slug( $page_id ) == 'page-templates/frontpage-template.php' ? true : false;
		}
	}
}// End if().
