<?php



function shop_entertainment_layout_customizer_settings( $wp_customize ){


	//ADD PANEL
	$wp_customize->add_panel('shop_entertainment_site_layout_option_panel',
		array(
			'title'      => esc_html__('Shop Entertainment - Customize Layout', 'shop-entertainment'),
			'priority'   => 2,
			'capability' => 'edit_theme_options',
		)
	);

	//BEGIN ADVERT BOX SECTION
	$wp_customize->add_section('shop_entertainment_header_box_section', array(
		'title' => __('Shop Entertainment - Logo and Advert Section', 'shop-entertainment'),
		'priority' => 10,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	$wp_customize->add_setting('shop_entertainment_header_box_display_settings', array(
	    'default' => __('none', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'shop_entertainment_header_box_display_control', array(
	    'label'    => __('Display Logo and Ad Section', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_header_box_section',
	    'settings' => 'shop_entertainment_header_box_display_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'block' => __('Yes', 'shop-entertainment'),
	    				'none' 	=> __('No', 'shop-entertainment'),
	    			   )
	)));

	
	//LOGO LINK COLOR
	$wp_customize->add_setting('shop_entertainment_header_box_logo_link_color_settings', array(
	    'default' => __('#353535', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_header_box_logo_link_color_control', array(
	    'label'    => __('Logo Text Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_header_box_section',
	    'settings' => 'shop_entertainment_header_box_logo_link_color_settings',
	)));


	/* BEGIN AD SECTION */

	/* END AD SECTION */


	//BEGIN NAVIGATION BACKGROUND COLOR SECTION
	$wp_customize->add_section('shop_entertainment_navbar_section', array(
		'title' => __('Shop Entertainment - Navbar BG Color', 'shop-entertainment'),
		'priority' => 10,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	
	//NAVBAR SECTION BACKGROUND COLOR
	$wp_customize->add_setting('shop_entertainment_navbar_section_bg_color_settings', array(
	    'default' => __('#bd1818', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_navbar_section_bg_color_control', array(
	    'label'    => __('Navbar Background Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_navbar_section',
	    'settings' => 'shop_entertainment_navbar_section_bg_color_settings',
	)));

	//NAVBAR SECTION TEXT COLOR
	$wp_customize->add_setting('shop_entertainment_navbar_section_text_color_settings', array(
	    'default' => __('#ffffff', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_navbar_section_text_color_control', array(
	    'label'    => __('Navbar Text Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_navbar_section',
	    'settings' => 'shop_entertainment_navbar_section_text_color_settings',
	)));

	//Shop Entertainment INDEX SECTION CLASS NAME
	$wp_customize->add_section('shop_entertainment_index_class_name_section', array(
		'title' => __('Shop Entertainment - Change Index Posts Style', 'shop-entertainment'),
		'priority' => 7,
		'panel'	=> 'shop_entertainment_site_layout_option_panel',
	));

	
	$wp_customize->add_setting('shop_entertainment_index_class_name_settings', array(
	    'default' => __('shop-entertainment-index', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'shop_entertainment_index_class_name_display_control', array(
	    'label'    => __('Change Style', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_index_class_name_section',
	    'settings' => 'shop_entertainment_index_class_name_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'shop-entertainment-index' 		=> __('List Layout - Right Sidebar', 'shop-entertainment'),
	    				'shop-entertainment-index-two' 	=> __('List Layout (Two Columns) - Right Sidebar', 'shop-entertainment'),
	    			   )
	)));


	//BEGIN MAGAZINE FEATURED SECTION
	$wp_customize->add_section('shop_entertainment_feature_section', array(
		'title' => __('Shop Entertainment - Featured Section', 'shop-entertainment'),
		'priority' => 8,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	$wp_customize->add_setting('shop_entertainment_feature_display_settings', array(
	    'default' => __('block', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'shop_entertainment_feature_display_control', array(
	    'label'    => __('Display Featured Section', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_feature_section',
	    'settings' => 'shop_entertainment_feature_display_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'block' => __('Yes', 'shop-entertainment'),
	    				'none' 	=> __('No', 'shop-entertainment'),
	    			   )
	)));

		//CHANGE STYLE FEATURE SECTION
	$wp_customize->add_setting('shop_entertainment_feature_change_style_settings', array(
	    'default' => __('shop-entertainment-feature', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'shop_entertainment_feature_change_style_control', array(
	    'label'    => __('Change Style', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_feature_section',
	    'settings' => 'shop_entertainment_feature_change_style_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'shop-entertainment-feature' 		=> __('Style 1 ( Right Side 2 Images )', 'shop-entertainment'),
	    				'shop-entertainment-feature-two' 	=> __('Style 2 ( 3 Columns )', 'shop-entertainment'),
	    			   )
	)));

		// BEGIN IMAGE GALLERY SECTION
	$wp_customize->add_section('shop_entertainment_img_gallery_section', array(
		'title' => __('Shop Entertainment - Image Gallery Section', 'shop-entertainment'),
		'priority' => 9,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	$wp_customize->add_setting('shop_entertainment_img_gallery_display_settings', array(
	    'default' => __('block', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'shop_entertainment_img_gallery_display_control', array(
	    'label'    => __('Display Image Gallery Section', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_img_gallery_section',
	    'settings' => 'shop_entertainment_img_gallery_display_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'block' => __('Yes', 'shop-entertainment'),
	    				'none' 	=> __('No', 'shop-entertainment'),
	    			   )
	)));


	//BEGIN MAGAZINE STACK MAG SECTION
	$wp_customize->add_section('shop_entertainment_stack_mag_section', array(
		'title' => __('Shop Entertainment - Stack Mag Section', 'shop-entertainment'),
		'priority' => 9,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	$wp_customize->add_setting('shop_entertainment_stack_mag_display_settings', array(
	    'default' => __('block', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'shop_entertainment_stack_mag_display_control', array(
	    'label'    => __('Display Stack Mag Section', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_stack_mag_section',
	    'settings' => 'shop_entertainment_stack_mag_display_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'block' => __('Yes', 'shop-entertainment'),
	    				'none' 	=> __('No', 'shop-entertainment'),
	    			   )
	)));


	//BEGIN Shop Entertainment READ MORE BACKGROUND COLOR SECTION
	$wp_customize->add_section('shop_entertainment_readmore_section', array(
		'title' => __('Shop Entertainment - Read More BG Color', 'shop-entertainment'),
		'priority' => 11,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	
	//Shop Entertainment READ MORE SECTION BACKGROUND COLOR
	$wp_customize->add_setting('shop_entertainment_readmore_bg_color_settings', array(
	    'default' => __('#ffffff', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_readmore_bg_color_control', array(
	    'label'    => __('Read More Background Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_readmore_section',
	    'settings' => 'shop_entertainment_readmore_bg_color_settings',
	)));
	
	//Shop Entertainment READ MORE SECTION BACKGROUND COLOR
	$wp_customize->add_setting('shop_entertainment_readmore_text_color_settings', array(
	    'default' => __('#424242', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_readmore_text_color_control', array(
	    'label'    => __('Read More Text Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_readmore_section',
	    'settings' => 'shop_entertainment_readmore_text_color_settings',
	)));

	//BEGIN SIDEBAR BACKGROUND COLOR SECTION
	$wp_customize->add_section('shop_entertainment_sidebar_section', array(
		'title' => __('Shop Entertainment - Sidebar Header BG Color', 'shop-entertainment'),
		'priority' => 11,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	
	//SIDEBAR SECTION BACKGROUND COLOR
	$wp_customize->add_setting('shop_entertainment_sidebar_header_bg_color_settings', array(
	    'default' => __('#ffffff', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_sidebar_header_bg_color_control', array(
	    'label'    => __('Sidebar Header Background Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_sidebar_section',
	    'settings' => 'shop_entertainment_sidebar_header_bg_color_settings',
	)));

		//SIDEBAR SECTION HEADER TEXT COLOR
	$wp_customize->add_setting('shop_entertainment_sidebar_header_title_color_settings', array(
	    'default' => __('#353535', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_sidebar_header_text_color_control', array(
	    'label'    => __('Sidebar Header Text Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_sidebar_section',
	    'settings' => 'shop_entertainment_sidebar_header_title_color_settings',
	)));

	//BEGIN Shop Entertainment PAGINATION BACKGROUND COLOR SECTION
	$wp_customize->add_section('shop_entertainment_pagination_section', array(
		'title' => __('Shop Entertainment - Pagination BG Color', 'shop-entertainment'),
		'priority' => 11,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	
	//Shop Entertainment PAGINATION SECTION BACKGROUND COLOR
	$wp_customize->add_setting('shop_entertainment_pagination_bg_color_settings', array(
	    'default' => __('#353535', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_pagination_bg_color_control', array(
	    'label'    => __('Page Numbers Background Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_pagination_section',
	    'settings' => 'shop_entertainment_pagination_bg_color_settings',
	)));


	//BEGIN Shop Entertainment SEARCH BUTTON SIDEBAR BACKGROUND COLOR SECTION
	$wp_customize->add_section('shop_entertainment_search_btn_sidebar_section', array(
		'title' => __('Shop Entertainment - Search Button BG Color', 'shop-entertainment'),
		'priority' => 11,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	
	//Shop Entertainment SEARCH BUTTON SIDEBAR SECTION BACKGROUND COLOR
	$wp_customize->add_setting('shop_entertainment_search_btn_sidebar_bg_color_settings', array(
	    'default' => __('#353535', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_search_btn_sidebar_bg_color_control', array(
	    'label'    => __('Search Button Sidebar Background Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_search_btn_sidebar_section',
	    'settings' => 'shop_entertainment_search_btn_sidebar_bg_color_settings',
	)));



	//BEGIN FOOTER BACKGROUND COLOR SECTION
	$wp_customize->add_section('shop_entertainment_footer_section', array(
		'title' => __('Shop Entertainment - Footer BG Color', 'shop-entertainment'),
		'priority' => 11,
		'panel' => 'shop_entertainment_site_layout_option_panel',
	));

	
	//FOOTER SECTION BACKGROUND COLOR
	$wp_customize->add_setting('shop_entertainment_footer_bg_color_settings', array(
	    'default' => __('#353535', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_footer_bg_color_control', array(
	    'label'    => __('footer Header Background Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_footer_section',
	    'settings' => 'shop_entertainment_footer_bg_color_settings',
	)));


	//FOOTER SECTION LINK TEXT COLOR
	$wp_customize->add_setting('shop_entertainment_footer_text_link_color_settings', array(
	    'default' => __('#fff', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_footer_text_link_color_control', array(
	    'label'    => __('Footer Link Text Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_footer_section',
	    'settings' => 'shop_entertainment_footer_text_link_color_settings',
	)));

	//FOOTER SECTION HEADER TITLE COLOR
	$wp_customize->add_setting('shop_entertainment_footer_header_text_color_settings', array(
	    'default' => __('#fff', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_hex_color',
	));

	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shop_entertainment_footer_header_text_color_control', array(
	    'label'    => __('Footer Header Title Text Color', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_footer_section',
	    'settings' => 'shop_entertainment_footer_header_text_color_settings',
	)));

	//FOOTER SECTION DISPLAY HEADER TITLE
	$wp_customize->add_setting('shop_entertainment_footer_display_header_text_settings', array(
	    'default' => __('block', 'shop-entertainment'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'shop_entertainment_footer_display_header_text_control', array(
	    'label'    => __('Footer Display Header Title', 'shop-entertainment'),
	    'section'  => 'shop_entertainment_footer_section',
	    'settings' => 'shop_entertainment_footer_display_header_text_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'block' => __('Yes', 'shop-entertainment'),
	    				'none' 	=> __('No', 'shop-entertainment'),
	    			   )
	)));

	$wp_customize->get_setting('shop_entertainment_header_box_display_settings')->transport 				= 	'postMessage';
	$wp_customize->get_setting('shop_entertainment_header_box_logo_link_color_settings')->transport 		= 	'postMessage';
	$wp_customize->get_setting('shop_entertainment_navbar_section_bg_color_settings')->transport 			= 	'postMessage';
	$wp_customize->get_setting('shop_entertainment_navbar_section_text_color_settings')->transport 		= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_readmore_bg_color_settings')->transport 				= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_readmore_text_color_settings')->transport 				= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_sidebar_header_bg_color_settings')->transport 			= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_sidebar_header_title_color_settings')->transport 		=	'postMessage';
    $wp_customize->get_setting('shop_entertainment_search_btn_sidebar_bg_color_settings')->transport 		= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_pagination_bg_color_settings')->transport 				= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_footer_bg_color_settings')->transport 					= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_footer_text_link_color_settings')->transport 			= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_footer_header_text_color_settings')->transport 		= 	'postMessage';
    $wp_customize->get_setting('shop_entertainment_footer_display_header_text_settings')->transport 		= 	'postMessage';


}


//CSS
function shop_entertainment_layout_custom_css(){
	?>

<style type="text/css">

.header-box .ad-box-img {
	display: <?php echo esc_html(get_theme_mod('shop_entertainment_ad_img_display_settings')); ?>
}

.header-box {
	display: <?php echo esc_html(get_theme_mod('shop_entertainment_header_box_display_settings')); ?>;
}

.header-box .logo .logo-text-link {
	color: <?php echo esc_html(get_theme_mod('shop_entertainment_header_box_logo_link_color_settings')); ?>;
}

.nav-outer {
	background: <?php echo esc_html(get_theme_mod('shop_entertainment_navbar_section_bg_color_settings')); ?>;
}

.theme-nav ul li a {
	color: <?php echo esc_html(get_theme_mod('shop_entertainment_navbar_section_text_color_settings')); ?>;
}

.shop-entertainment-index .blog-2-col-inner .items .items-inner .img-box .details-box .details-box-inner .btn-case a {
	background: <?php echo esc_html(get_theme_mod('shop_entertainment_readmore_bg_color_settings')); ?>;
	color: <?php echo esc_html( get_theme_mod('shop_entertainment_readmore_text_color_settings')); ?>;
}

.shop-entertainment-no-feature {
	display: <?php echo esc_html(get_theme_mod('shop_entertainment_feature_display_settings')); ?>;
}

.shop-entertainment-no-img-gallery {
	display: <?php echo esc_html(get_theme_mod('shop_entertainment_img_gallery_display_settings')); ?>;
}

.shop-entertainment-no-diff {
	display: <?php echo esc_html(get_theme_mod('shop_entertainment_stack_mag_display_settings')); ?>;
}

.sidebar .sidebar-inner .sidebar-items h2 {
	background: <?php echo esc_html(get_theme_mod('shop_entertainment_sidebar_header_bg_color_settings')); ?>;
	color: <?php echo esc_html(get_theme_mod('shop_entertainment_sidebar_header_title_color_settings')); ?>;
}

.sidebar .sidebar-inner .sidebar-items .searchform div #searchsubmit {
	background: <?php echo esc_html(get_theme_mod('shop_entertainment_search_btn_sidebar_bg_color_settings')); ?>;
}

.page-numbers {
	background: <?php echo esc_html(get_theme_mod('shop_entertainment_pagination_bg_color_settings')); ?>;	
}

.footer-4-col {
	background: <?php echo esc_html(get_theme_mod('shop_entertainment_footer_bg_color_settings')); ?>; 
}

.footer-4-col .inner .footer .footer-inner .footer-items a {
	color: <?php echo esc_html(get_theme_mod('shop_entertainment_footer_text_link_color_settings')); ?>;
}

.footer-4-col .inner .footer .footer-inner .footer-items li h2 {
	display: <?php echo esc_html(get_theme_mod('shop_entertainment_footer_display_header_text_settings')); ?>;
	color: <?php echo esc_html(get_theme_mod('shop_entertainment_footer_header_text_color_settings')); ?>;
}

</style>


	<?php

}


function shop_entertainment_layout_customizer_live_preview()
{
	wp_enqueue_script( 
		  'shop-entertainment-site-layout-customizer',			
		  get_template_directory_uri().'/js/shop-entertainment-layout-customizer.js',
		  array( 'jquery','customize-preview' ),	
		  '',						
		  true						
	);
}




add_action('wp_head', 'shop_entertainment_layout_custom_css');
add_action('customize_register', 'shop_entertainment_layout_customizer_settings');
add_action( 'customize_preview_init', 'shop_entertainment_layout_customizer_live_preview' );


?>