<?php
//options

function shop_entertainment_theme_info_menu() {

	add_theme_page( 
		esc_html__('Welcome To Shop Entertainment WordPress Theme', 'shop-entertainment'), 
		esc_html__('Shop Entertainment Theme Info', 'shop-entertainment'), 
		'manage_options', 
		'shop_entertainment_theme_info_options', 
		'shop_entertainment_theme_info_display' 
	);

}


add_action( 'admin_menu', 'shop_entertainment_theme_info_menu' );



function shop_entertainment_theme_info_display() {
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( esc_html_e( 'You do not have sufficient permissions to access this page.', 'shop-entertainment' ) );
	}
	
	?>
	<div class="wrap shop-entertainment-adm">
		<h1 class="header-welcome"><?php esc_html_e('Welcome to Shop Entertainment - 0.1.25', 'shop-entertainment'); ?></h1>
		<div class="shop-entertainment-adm-dsply-fl shop-entertainment-adm-fl-wrap shop-entertainment-adm-jc-sp-btw">

			<div class="shop-entertainment-adm-wid-49 theme-para theme-doc shop-entertainment-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Documentation','shop-entertainment'); ?></h4>
				<p><?php esc_html_e('Documentation for this theme includes all theme information that is needed to get your site up and running', 'shop-entertainment'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://zidithemes.com/shop-entertainment/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Theme Documentation', 'shop-entertainment'); ?>
					</a>
				</p>
			</div>

			<div class="shop-entertainment-adm-wid-49 theme-para theme-opt shop-entertainment-adm-mobwid-100">
				<h4><?php esc_html_e('Shop Entertainment Pro','shop-entertainment'); ?></h4>
				<p class="">
					<?php esc_html_e('Shop Entertainment Pro includes portfolio page templates, additional features and more options to customize your website.',  'shop-entertainment'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url('https://zidithemes.com/shop-entertainment-pro/'); ?>" class="button button-primary" target="_blank">
						<?php esc_html_e('Upgrade to Shop Entertainment Pro', 'shop-entertainment'); ?>
					</a>
				</p>
			</div>

			<div class="shop-entertainment-adm-wid-49 theme-para theme-opt shop-entertainment-adm-mobwid-100">
				<h4><?php esc_html_e('Theme Options','shop-entertainment'); ?></h4>
				<p class="">
					<?php esc_html_e('Shop Entertainment Theme supports Theme Customizer. Click "Go To Customizer" to open the Customizer now.',  'shop-entertainment'); ?>
				</p>
				<p>
					<a href="<?php echo esc_url(admin_url('customize.php')); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Go To Customizer', 'shop-entertainment'); ?>
					</a>
				</p>
			</div>
			
			<div class="shop-entertainment-adm-wid-49 theme-para theme-doc shop-entertainment-adm-mobwid-100">
				<h4><?php esc_html_e('Watch Tutorial on Shop Entertainment','shop-entertainment'); ?></h4>
				<p><?php esc_html_e('Watch Youtube tutorial on how to install and use Shop Entertainment theme.', 'shop-entertainment'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://www.youtube.com/watch?v=m_XOWEO3I9M'); ?>" class="button button-secondary button-youtube" target="_blank">
						<?php esc_html_e('Watch Shop Entertainment Tutorial', 'shop-entertainment'); ?>
					</a>
				</p>
			</div>

			<div class="shop-entertainment-adm-wid-49 theme-para theme-review shop-entertainment-adm-mobwid-100">
				<h4><?php esc_html_e('Leave us a review','shop-entertainment'); ?></h4>
				<p><?php esc_html_e('We would love to hear your feedback.', 'shop-entertainment'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/shop-entertainment/reviews/#new-post'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Submit a review', 'shop-entertainment'); ?>
					</a>
				</p>
			</div>


			<div class="shop-entertainment-adm-wid-49 theme-para theme-support shop-entertainment-adm-mobwid-100">
				<h4><?php esc_html_e('Support','shop-entertainment'); ?></h4>
				<p><?php esc_html_e('Reach out in the theme support forums on WordPress.org.', 'shop-entertainment'); ?></p>
				<p>
					<a href="<?php echo esc_url('https://wordpress.org/support/theme/shop-entertainment/'); ?>" class="button button-secondary" target="_blank">
						<?php esc_html_e('Support Forum', 'shop-entertainment'); ?>
					</a>
				</p>
			</div>


			<div class="theme-upgrade shop-entertainment-adm-wid-100">
				<table class="shop-entertainment-adm-wid-100">
					<thead class="theme-table-head">
						<tr>
							<th class="feature"><h3><?php esc_html_e('Features', 'shop-entertainment'); ?></h3></th>
							<th class="shop-entertainment-adm-wid-33"><h3><?php esc_html_e('Shop Entertainment', 'shop-entertainment'); ?></h3></th>
							<th class="shop-entertainment-adm-wid-33"><h3><?php esc_html_e('Shop Entertainment Pro', 'shop-entertainment'); ?></h3></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Number Of Featured Section Styles', 'shop-entertainment'); ?></h3></td>
							<td><span class="number-index-styles"><?php esc_html_e('2', 'shop-entertainment'); ?></span></td>
							<td><span class="number-index-styles"><?php esc_html_e('10', 'shop-entertainment'); ?></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Number Of Index Posts Styles', 'shop-entertainment'); ?></h3></td>
							<td><span class="number-index-styles"><?php esc_html_e('2', 'shop-entertainment'); ?></span></td>
							<td><span class="number-index-styles"><?php esc_html_e('14', 'shop-entertainment'); ?></span></td>
						</tr>
						<tr>
							<td class="feature-items-title">
								<h3><?php esc_html_e('Theme Price', 'shop-entertainment'); ?></h3>
							</td>
							<td class="free-btn"><?php esc_html_e('Free', 'shop-entertainment'); ?></td>
							<td>
								<a class="pro-link-btn" href="<?php echo esc_url('https://zidithemes.com/shop-entertainment-pro/'); ?>" target="_blank">
									<?php esc_html_e('View Pricing', 'shop-entertainment'); ?>
								</a>
							</td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Responsive Design', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Portfolio Page Template', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Testimonials Page Template', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Team Page Template', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gallery Page Template', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Pricing Page Template', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('One Column Post Template', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('3 News Grid Image Styles', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Full Width Template', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Footer Credits Options', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-no"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Color Options', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Gutenberg Compatible', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Elementor Compatible', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Major Browser Compatible', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class="feature-items-title"><h3><?php esc_html_e('Woocommerce Compatible', 'shop-entertainment'); ?></h3></td>
							<td><span class="dashicons dashicons-yes"></span></td>
							<td><span class="dashicons dashicons-yes"></span></td>
						</tr>
						<tr>
							<td class=""></td>
							<td class=""></td>
							<td class="go-pro">
								<span class="">
									<a class="link" href="<?php echo esc_url('https://zidithemes.com/shop-entertainment-pro/'); ?>" target="_blank">
										<?php esc_html_e('View Pro', 'shop-entertainment'); ?>
									</a>
								</span>
							</td>
						</tr>
					</tbody>
				</table>
			</div>

		</div>
	</div>
	<?php
}
?>
