<?php
/**
 * pagination options
 *
 * @package Theme Palace
 * @subpackage  Workart
 * @since  Workart 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'workart_pagination',
	array(
		'title'               	=> esc_html__('Pagination','workart'),
		'description'         	=> esc_html__( 'Pagination section options.', 'workart' ),
		'panel'               	=> 'workart_theme_options_panel',
	)
);

// Sidebar position setting and control.
$wp_customize->add_setting( 'workart_theme_options[pagination_enable]',
	array(
		'sanitize_callback' 	=> 'workart_sanitize_switch_control',
		'default'             	=> $options['pagination_enable'],
	)
);

$wp_customize->add_control( new  Workart_Switch_Control( $wp_customize,
	'workart_theme_options[pagination_enable]',
		array(
			'label'               	=> esc_html__( 'Pagination Enable', 'workart' ),
			'section'             	=> 'workart_pagination',
			'on_off_label' 			=> workart_switch_options(),
		)
	)
);

// Site layout setting and control.
$wp_customize->add_setting( 'workart_theme_options[pagination_type]',
	array(
		'sanitize_callback'   	=> 'workart_sanitize_select',
		'default'             	=> $options['pagination_type'],
	)
);

$wp_customize->add_control( 'workart_theme_options[pagination_type]',
	array(
		'label'               	=> esc_html__( 'Pagination Type', 'workart' ),
		'section'             	=> 'workart_pagination',
		'type'                	=> 'select',
		'choices'			  	=> workart_pagination_options(),
		'active_callback'	  	=> 'workart_is_pagination_enable',
	)
);
